<?php
header("Content-Type: application/json");
include 'db.php';

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Check if input is valid
if (!$input || !isset($input['id'])) {
    die(json_encode(['status' => 'error', 'message' => 'Invalid input or missing ID']));
}

// Prepare data
$id = $conn->real_escape_string($input['id']);
$firstname = isset($input['firstname']) ? "'".$conn->real_escape_string($input['firstname'])."'" : "''";
$lastname = isset($input['lastname']) ? "'".$conn->real_escape_string($input['lastname'])."'" : "''";
$email = isset($input['email']) ? "'".$conn->real_escape_string($input['email'])."'" : "''";
$phonenumber = isset($input['phonenumber']) ? "'".$conn->real_escape_string($input['phonenumber'])."'" : "''";

// Build SQL query
$sql = "UPDATE customer SET 
        primarycontact = $firstname,
        displayname = CONCAT($firstname, ' ', $lastname),
        email = $email,
        phoneno = $phonenumber
        WHERE id = '$id'";

// Execute query
if ($conn->query($sql)) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Customer updated'
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Update failed: ' . $conn->error
    ]);
}

$conn->close();
?>